/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.exportaciones;

import ec.gob.sri.dimm.api.ui.asistentes.AsistenteBase;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.exportacion.Exportacion;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.exportaciones.PaginaCliente;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.exportaciones.PaginaComprobante;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.exportaciones.PaginaRefrendo;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;

public class AsistenteEdicionExportaciones
extends AsistenteBase
implements INewWizard {
    private PaginaCliente paginaCliente;
    private PaginaRefrendo paginaRefrendo;
    private PaginaComprobante paginaComprobante;
    private final Exportacion modeloDatos;
    private SeccionExportaciones seccion;

    public AsistenteEdicionExportaciones(Exportacion exportacion, SeccionExportaciones seccion) {
        this.modeloDatos = exportacion;
        this.modeloDatos.getComprobanteExportacion().setObligatorio(true);
        this.seccion = seccion;
    }

    public void addPages() {
        switch (this.seccion) {
            case CLIENTE: {
                this.paginaCliente = new PaginaCliente(true, ((Iva)this.modeloDatos.getPropietario()).periodo);
                this.paginaCliente.setModeloDatos(this.modeloDatos.getClienteExportacion());
                this.paginaCliente.inicializarModeloValores();
                this.addPage((IWizardPage)this.paginaCliente);
                break;
            }
            case REFRENDO: {
                this.paginaRefrendo = new PaginaRefrendo(true);
                this.paginaRefrendo.setModeloDatos(this.modeloDatos);
                this.paginaRefrendo.inicializarModeloValores();
                this.addPage((IWizardPage)this.paginaRefrendo);
                break;
            }
            case COMPROBANTE: {
                this.paginaComprobante = new PaginaComprobante(true);
                this.paginaComprobante.setModeloDatos(this.modeloDatos.getComprobanteExportacion());
                this.paginaComprobante.inicializarModeloValores();
                this.addPage((IWizardPage)this.paginaComprobante);
                break;
            }
        }
    }

    public boolean performFinish() {
        return true;
    }

    public static enum SeccionExportaciones {
        CLIENTE,
        REFRENDO,
        COMPROBANTE;

    }
}

